/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.ArrayNodeDiff;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.Column;
import org.autoplot.dom.Connector;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DebugPropertyChangeSupport;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PropertyChangeDiff;
import org.autoplot.dom.Row;
import org.autoplot.state.StatePersistence;
import org.das2.beans.BeansUtil;
import org.das2.components.propertyeditor.Displayable;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.qds.QDataSet;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class DomUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.util");
    public static final Converter STRING_TO_FONT = new Converter(){

        public Object convertForward(Object value) {
            return Font.decode((String)value);
        }

        public Object convertReverse(Object value) {
            return DomUtil.encodeFont((Font)value);
        }
    };
    public static final Converter STRING_TO_COLOR = new Converter(){

        public Object convertForward(Object value) {
            return Color.decode((String)value);
        }

        public Object convertReverse(Object value) {
            return DomUtil.encodeColor((Color)value);
        }
    };
    public static final Converter AUTO_TO_COLOR = new Converter(){

        public Object convertForward(Object value) {
            boolean b = (Boolean)value;
            return b ? Color.WHITE : Color.LIGHT_GRAY;
        }

        public Object convertReverse(Object value) {
            return Color.WHITE.equals(value);
        }
    };

    public static String abbreviateRight(String s, int len) {
        if (s == null) {
            return "<null>";
        }
        if (s.length() > len) {
            s = "..." + s.substring(s.length() - len);
        }
        return s;
    }

    static List<String> childProperties(List<String> exclude, String string) {
        ArrayList<String> result = new ArrayList<String>();
        int n = string.length() + 1;
        for (String e : exclude) {
            if (!e.startsWith(string + ".")) continue;
            result.add(e.substring(n));
        }
        return result;
    }

    static List<DomNode> dataSourceUsages(Application app, String id) {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        for (PlotElement plotElement : app.getPlotElements()) {
            if (!plotElement.getDataSourceFilterId().equals(id)) continue;
            result.add(plotElement);
        }
        for (DomNode domNode : app.getDataSourceFilters()) {
            String[] ss;
            if (!((DataSourceFilter)domNode).getUri().startsWith("vap+internal:")) continue;
            for (String s : ss = ((DataSourceFilter)domNode).getUri().substring(13).split(",", -2)) {
                if (!s.equals(id) || result.contains(domNode)) continue;
                result.add(domNode);
            }
        }
        return result;
    }

    public static void moveToJustBelow(Application dom, String referenceId, String pId) {
        int top;
        PlotElement p;
        PlotElement reference = (PlotElement)DomUtil.getElementById(dom, referenceId);
        if (reference == (p = (PlotElement)DomUtil.getElementById(dom, pId))) {
            throw new IllegalArgumentException("reference and p are the same plot element");
        }
        if (!reference.getPlotId().equals(p.getPlotId())) {
            throw new IllegalArgumentException("reference and p must be in the same plot");
        }
        ArrayList<PlotElement> newPes = new ArrayList<PlotElement>(Arrays.asList(dom.getPlotElements()));
        for (top = newPes.size() - 1; top >= 0 && newPes.get(top) != reference; --top) {
        }
        for (int ploc = 0; ploc < newPes.size() && newPes.get(ploc) != p; ++ploc) {
        }
        newPes.remove(p);
        newPes.add(top - 1, p);
        dom.setPlotElements(newPes.toArray(new PlotElement[newPes.size()]));
    }

    public static void moveToJustAbove(Application dom, String referenceId, String pId) {
        int ploc;
        int top;
        PlotElement p;
        PlotElement reference = (PlotElement)DomUtil.getElementById(dom, referenceId);
        if (reference == (p = (PlotElement)DomUtil.getElementById(dom, pId))) {
            throw new IllegalArgumentException("reference and p are the same plot element");
        }
        if (!reference.getPlotId().equals(p.getPlotId())) {
            throw new IllegalArgumentException("reference and p must be in the same plot");
        }
        ArrayList<PlotElement> newPes = new ArrayList<PlotElement>(Arrays.asList(dom.getPlotElements()));
        for (top = newPes.size() - 1; top >= 0 && newPes.get(top) != reference; --top) {
        }
        for (ploc = 0; ploc < newPes.size() && newPes.get(ploc) != p; ++ploc) {
        }
        newPes.remove(p);
        if (ploc < top) {
            newPes.add(top, p);
        } else {
            newPes.add(top + 1, p);
        }
        dom.setPlotElements(newPes.toArray(new PlotElement[newPes.size()]));
    }

    private static Object setGetPropertyInternal(DomNode node, String propertyName, boolean setit, boolean getClass, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String[] props = propertyName.split("\\.", -2);
        Pattern indexedPattern = Pattern.compile("([a-zA-Z_]+)\\[(\\d+)\\]");
        Object thisNode = node;
        block0: for (int iprop = 0; iprop < props.length; ++iprop) {
            String name;
            String prop1 = props[iprop];
            Matcher m = indexedPattern.matcher(prop1);
            PropertyDescriptor[] pds = BeansUtil.getPropertyDescriptors(thisNode.getClass());
            if (m.matches()) {
                name = m.group(1);
                int idx = Integer.parseInt(m.group(2));
                PropertyDescriptor[] propertyDescriptorArray = pds;
                int n = propertyDescriptorArray.length;
                for (int i = 0; i < n; ++i) {
                    PropertyDescriptor pd = propertyDescriptorArray[i];
                    if (!pd.getName().equals(name)) continue;
                    Object thisValue = ((IndexedPropertyDescriptor)pd).getIndexedReadMethod().invoke(thisNode, idx);
                    if (iprop == props.length - 1) {
                        if (setit) {
                            ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod().invoke(thisNode, idx, value);
                        } else {
                            if (getClass) {
                                return ((IndexedPropertyDescriptor)pd).getPropertyType();
                            }
                            return thisValue;
                        }
                    }
                    thisNode = thisValue;
                    continue block0;
                }
                continue;
            }
            name = prop1;
            for (PropertyDescriptor pd : pds) {
                if (!pd.getName().equals(name)) continue;
                Object thisValue = pd.getReadMethod().invoke(thisNode, new Object[0]);
                if (iprop == props.length - 1) {
                    if (setit) {
                        pd.getWriteMethod().invoke(thisNode, value);
                    } else {
                        if (getClass) {
                            return pd.getPropertyType();
                        }
                        return thisValue;
                    }
                }
                thisNode = thisValue;
                continue block0;
            }
        }
        if (!setit) {
            throw new IllegalArgumentException("unable to find property \"" + propertyName + "\" in " + node);
        }
        return null;
    }

    public static Object getPropertyValue(DomNode node, String propertyName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return DomUtil.setGetPropertyInternal(node, propertyName, false, false, null);
    }

    public static void setPropertyValue(DomNode node, String propertyName, Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DomUtil.setGetPropertyInternal(node, propertyName, true, false, val);
    }

    public static Class getPropertyType(DomNode node, String propertyName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Class)DomUtil.setGetPropertyInternal(node, propertyName, false, true, null);
    }

    static List<DomNode> rowUsages(Application dom, String rowId) {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        for (Plot plot : dom.getPlots()) {
            if (!plot.getRowId().equals(rowId)) continue;
            result.add(plot);
        }
        for (DomNode domNode : dom.getAnnotations()) {
            if (!((Annotation)domNode).getRowId().equals(rowId)) continue;
            result.add(domNode);
        }
        return result;
    }

    static List<DomNode> columnUsages(Application dom, String columnId) {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        for (Plot plot : dom.getPlots()) {
            if (!plot.getColumnId().equals(columnId)) continue;
            result.add(plot);
        }
        for (DomNode domNode : dom.getAnnotations()) {
            if (!((Annotation)domNode).getColumnId().equals(columnId)) continue;
            result.add(domNode);
        }
        return result;
    }

    private static DatumRange round(DatumRange range) {
        Datum w = range.width();
        Datum w0 = DatumUtil.asOrderOneUnits((Datum)w);
        Units hu = w0.getUnits();
        Datum base = range.getUnits().isConvertibleTo((Units)Units.us2000) ? TimeUtil.prevMidnight((Datum)range.min()) : w.getUnits().createDatum(0);
        double min10 = Math.round(range.min().subtract(base).doubleValue(w0.getUnits()));
        double max10 = Math.round(range.max().subtract(base).doubleValue(w0.getUnits()));
        return new DatumRange(base.add(Datum.create((double)min10, (Units)hu)), base.add(Datum.create((double)max10, (Units)hu)));
    }

    public static String describe(DatumRange init, DatumRange fin) {
        if (init.getUnits().isConvertibleTo(fin.getUnits())) {
            String scaleString = "";
            if (UnitsUtil.isTimeLocation((Units)fin.getUnits())) {
                Datum scale = DatumUtil.asOrderOneUnits((Datum)DomUtil.round(fin).width());
                scaleString = " to " + scale;
            }
            if (init.contains(fin)) {
                return "zoom in" + scaleString;
            }
            if (fin.contains(init)) {
                return "zoom out" + scaleString;
            }
            if (init.intersects(fin)) {
                return "pan";
            }
            return "scan";
        }
        return "" + DomUtil.round(init) + " \u2192 " + DomUtil.round(fin);
    }

    public static Object parseObject(Object context, String s) {
        PropertyEditor edit = BeansUtil.findEditor(context.getClass());
        if (edit == null) {
            return context;
        }
        edit.setValue(context);
        edit.setAsText(s);
        Object result = edit.getValue();
        return result;
    }

    public static String formatObject(Object obj) {
        PropertyEditor edit = BeansUtil.findEditor(obj.getClass());
        if (edit == null) {
            return "";
        }
        edit.setValue(obj);
        String result = edit.getAsText();
        return result;
    }

    public static DomNode getElementById(DomNode root, String id, boolean allowEmpty) {
        if (id.equals("") && allowEmpty) {
            return null;
        }
        return DomUtil.getElementById(root, id);
    }

    public static DomNode getElementById(DomNode root, String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("id cannot be zero-length string");
        }
        if (root.getId().equals(id)) {
            return root;
        }
        for (DomNode n : root.childNodes()) {
            if (n.getId().equals(id)) {
                return n;
            }
            DomNode nn = DomUtil.getElementById(n, id);
            if (nn == null) continue;
            return nn;
        }
        return null;
    }

    public static DomNode getElementByAddress(DomNode domNode, String address) {
        String[] ss;
        for (String s : ss = address.split("\\.")) {
            try {
                Object o;
                Method getter;
                PropertyDescriptor pd;
                int index;
                Pattern p = Pattern.compile("([a-zA-Z]+)(\\[(\\d+)\\])?");
                Matcher m = p.matcher(s);
                if (m.matches()) {
                    index = m.group(2) != null ? Integer.parseInt(m.group(3)) : -1;
                } else {
                    throw new IllegalArgumentException("regex doesn't match");
                }
                String prop = m.group(1);
                Class<?> c = domNode.getClass();
                if (index > -1) {
                    pd = new IndexedPropertyDescriptor(prop, c);
                    getter = ((IndexedPropertyDescriptor)pd).getIndexedReadMethod();
                    o = getter.invoke((Object)domNode, index);
                } else {
                    pd = new PropertyDescriptor(prop, c);
                    getter = pd.getReadMethod();
                    o = getter.invoke((Object)domNode, new Object[0]);
                }
                if (!(o instanceof DomNode)) {
                    throw new IllegalArgumentException("address is not that of a node (is it a property?)");
                }
                domNode = (DomNode)o;
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return domNode;
    }

    public static Plot getPlotForAxis(Application app, Axis oa) {
        for (Plot p : app.getPlots()) {
            if (p.getXaxis() == oa) {
                return p;
            }
            if (p.getYaxis() == oa) {
                return p;
            }
            if (p.getZaxis() != oa) continue;
            return p;
        }
        return null;
    }

    public static List<DomNode> findElementsById(DomNode root, String regex) {
        if (regex == null || regex.equals("")) {
            throw new IllegalArgumentException("id cannot be null or zero-length string");
        }
        Pattern p = Pattern.compile(regex);
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        if (p.matcher(root.getId()).matches()) {
            result.add(root);
        }
        for (DomNode n : root.childNodes()) {
            if (p.matcher(n.getId()).matches()) {
                result.add(n);
            }
            result.addAll(DomUtil.findElementsById(n, regex));
        }
        return result;
    }

    public static <T> ArrayList<T> asArrayList(T ... a) {
        return new ArrayList<T>(Arrays.asList(a));
    }

    public static Diff childDiff(String childName, Diff diff) {
        if (diff instanceof PropertyChangeDiff) {
            PropertyChangeDiff pcd = (PropertyChangeDiff)diff;
            return new PropertyChangeDiff(childName + "." + pcd.propertyName, pcd.oldVal, pcd.newVal);
        }
        if (diff instanceof ArrayNodeDiff) {
            ArrayNodeDiff d = (ArrayNodeDiff)diff;
            return new ArrayNodeDiff(childName + "." + d.propertyName, d.action, d.node, d.index, d.toIndex);
        }
        return null;
    }

    public static List<Diff> childDiffs(String childName, List<Diff> diffs) {
        ArrayList<Diff> result = new ArrayList<Diff>();
        for (Diff diff : diffs) {
            Diff r1 = DomUtil.childDiff(childName, diff);
            if (r1 == null) continue;
            result.add(r1);
        }
        return result;
    }

    public static int indexOf(List<Object> nodes, Object node) {
        if (node == null) {
            throw new NullPointerException("node is null");
        }
        boolean isDomNode = node instanceof DomNode;
        if (!isDomNode) {
            return nodes.indexOf(node);
        }
        String findId = ((DomNode)node).id;
        for (int i = 0; i < nodes.size(); ++i) {
            DomNode n1 = (DomNode)nodes.get(i);
            if (n1 == node) {
                return i;
            }
            String id = n1.getId();
            if (id.equals("") || !id.equals(findId)) continue;
            return i;
        }
        return -1;
    }

    public static void deleteDataSourceFilter(Application application, DataSourceFilter dsf) {
        if (!application.dataSourceFilters.contains(dsf)) {
            logger.fine("dsf wasn't part of the application");
            return;
        }
        if (application.dataSourceFilters.size() < 2) {
            throw new IllegalArgumentException("last plot cannot be deleted");
        }
        List<DomNode> plotElements = DomUtil.dataSourceUsages(application, dsf.id);
        if (plotElements.size() > 0) {
            throw new IllegalArgumentException("application plot elements use dsf");
        }
        for (DataSourceFilter dsf1 : application.getDataSourceFilters()) {
            String uri = dsf1.getUri();
            if (!uri.startsWith("vap+internal:") || !uri.contains(dsf.id)) continue;
            throw new IllegalArgumentException("dsf is used as parent of " + dsf1.getId());
        }
        ArrayList<DataSourceFilter> alsoRemove = new ArrayList<DataSourceFilter>();
        if (dsf.getUri().startsWith("vap+internal:")) {
            List<DataSourceFilter> parents = DomUtil.getParentsFor(application, dsf.getUri());
            for (DataSourceFilter pdf : parents) {
                if (pdf == null) continue;
                String dsfId = pdf.getId();
                List<DomNode> usages = DomUtil.dataSourceUsages(application, dsfId);
                usages.remove(dsf);
                if (!usages.isEmpty()) continue;
                alsoRemove.add(pdf);
            }
        }
        ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>(Arrays.asList(application.getDataSourceFilters()));
        dsfs.remove(dsf);
        dsfs.removeAll(alsoRemove);
        application.setDataSourceFilters(dsfs.toArray(new DataSourceFilter[dsfs.size()]));
    }

    /*
     * WARNING - void declaration
     */
    public static List<Diff> getArrayDiffs(String property, Object[] nodes1, Object[] nodes2) {
        void var10_15;
        void var10_13;
        LinkedList<Diff> result = new LinkedList<Diff>();
        ArrayList<Object> node1List = new ArrayList<Object>(Arrays.asList(nodes1));
        ArrayList<Object> node2List = new ArrayList<Object>(Arrays.asList(nodes2));
        ArrayList<Object> deleteList = new ArrayList<Object>();
        int i2 = 0;
        Object[] objectArray = nodes2;
        int n = objectArray.length;
        boolean bl = false;
        while (var10_13 < n) {
            Object object = objectArray[var10_13];
            if (DomUtil.indexOf(node2List, object) != i2) {
                deleteList.add(object);
                logger.log(Level.WARNING, "two nodes have the same ID: {0}", object);
            }
            ++i2;
            ++var10_13;
        }
        objectArray = nodes2;
        n = objectArray.length;
        boolean bl2 = false;
        while (var10_15 < n) {
            Object object = objectArray[var10_15];
            if (DomUtil.indexOf(node1List, object) == -1) {
                deleteList.add(object);
            }
            ++var10_15;
        }
        boolean isDomNode = DomNode.class.isAssignableFrom(nodes1.getClass().getComponentType());
        for (Object e : deleteList) {
            int n2 = DomUtil.indexOf(node2List, e);
            result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Delete, node2List.get(n2), n2));
            node2List.remove(n2);
        }
        ArrayList<Object> addList = new ArrayList<Object>();
        for (Object o : nodes1) {
            if (DomUtil.indexOf(node2List, o) != -1) continue;
            addList.add(o);
        }
        for (Object e : addList) {
            int idx = DomUtil.indexOf(node1List, e);
            if (nodes1[idx] instanceof DomNode) {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Insert, ((DomNode)nodes1[idx]).copy(), idx));
            } else {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Insert, nodes1[idx], idx));
            }
            node2List.add(idx, nodes1[idx]);
        }
        if (node1List.size() != node2List.size()) {
            logger.warning("2057: bug where two nodes have the duplicate ID detected.");
        }
        if (isDomNode) {
            void var10_20;
            boolean bl3 = false;
            while (var10_20 < node1List.size()) {
                result.addAll(DomUtil.childDiffs(property + "[" + (int)var10_20 + "]", DomUtil.getDiffs((DomNode)node1List.get((int)var10_20), (DomNode)node2List.get((int)var10_20))));
                ++var10_20;
            }
        }
        return result;
    }

    public static List<Diff> getDiffs(DomNode node1, DomNode node2) {
        return DomUtil.getDiffs(node1, node2, null);
    }

    public static List<Diff> getDiffs(DomNode node1, DomNode node2, List<String> exclude) {
        String[] props = BeansUtil.getPropertyNames(node1.getClass());
        PropertyDescriptor[] pds = BeansUtil.getPropertyDescriptors(node1.getClass());
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].equals("controller") || exclude != null && exclude.contains(props[i])) continue;
            try {
                Object val1 = pds[i].getReadMethod().invoke((Object)node1, new Object[0]);
                Object val2 = pds[i].getReadMethod().invoke((Object)node2, new Object[0]);
                if (pds[i] instanceof IndexedPropertyDescriptor) {
                    diffs.addAll(DomUtil.getArrayDiffs(props[i], (DomNode[])val1, (DomNode[])val2));
                    continue;
                }
                if (DomNode.class.isAssignableFrom(pds[i].getReadMethod().getReturnType())) {
                    diffs.addAll(DomUtil.childDiffs(props[i], ((DomNode)val1).diffs((DomNode)val2)));
                    continue;
                }
                if (val1 == val2 || val1 != null && val1.equals(val2)) continue;
                diffs.add(new PropertyChangeDiff(props[i], val2, val1));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return diffs;
    }

    public static void syncTo(DomNode node1, DomNode node2) {
        List<Diff> diffs = node2.diffs(node1);
        for (Diff d : diffs) {
            d.doDiff(node1);
        }
    }

    public static void syncTo(DomNode node1, DomNode node2, List<String> exclude) {
        List<Diff> diffs = node2.diffs(node1);
        for (Diff d : diffs) {
            if (exclude.contains(d.propertyName())) continue;
            d.doDiff(node1);
        }
    }

    public static String encodeColor(Color c) {
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
    }

    public static String encodeFont(Font f) {
        String style = "-";
        if (f.isBold()) {
            style = style + "bold";
        }
        if (f.isItalic()) {
            style = style + "italic";
        }
        String result = f.getFamily();
        if (style.length() > 1) {
            result = result + style;
        }
        return result + "-" + f.getSize();
    }

    public static boolean oneFamily(List<PlotElement> elementsIn) {
        if (elementsIn.isEmpty()) {
            return false;
        }
        ArrayList<PlotElement> elements = new ArrayList<PlotElement>(elementsIn);
        PlotElement pe = (PlotElement)elements.get(0);
        if (pe.getController().getParentPlotElement() != null) {
            pe = pe.getController().getParentPlotElement();
        }
        elements.remove(pe);
        elements.removeAll(pe.getController().getChildPlotElements());
        return elements.isEmpty();
    }

    public static List<DataSourceFilter> getParentsFor(Application dom, String uri) {
        String parents = uri.substring(13);
        if (parents.trim().length() == 0) {
            return Collections.emptyList();
        }
        String[] dep = parents.split(",");
        ArrayList<DataSourceFilter> result = new ArrayList<DataSourceFilter>();
        for (String dep1 : dep) {
            result.add((DataSourceFilter)DomUtil.getElementById(dom, dep1));
        }
        return result;
    }

    private static void checkIds(HashSet<String> ids, DomNode[] n, List<String> problems) {
        for (DomNode n1 : n) {
            if (ids.contains(n1.id)) {
                problems.add("multiple nodes have the same id: " + n1.id);
            }
            ids.add(n1.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateDom(Application application, List<String> problems) {
        ChangesSupport.DomLock lock = null;
        if (application.getController() != null) {
            lock = application.getController().mutatorLock();
            lock.lock("Validate DOM");
        }
        try {
            DomNode p;
            int i;
            for (i = 0; i < application.getBindings().length; ++i) {
                BindingModel b = application.getBindings(i);
                if (DomUtil.getElementById(application, b.getSrcId()) == null) {
                    problems.add("unable to find source " + b.getSrcId() + " for binding " + i);
                }
                if (DomUtil.getElementById(application, b.getDstId()) != null) continue;
                problems.add("unable to find dest " + b.getSrcId() + " for binding " + i);
            }
            for (i = 0; i < application.getDataSourceFilters().length; ++i) {
                String[] dep;
                DataSourceFilter dsf = application.getDataSourceFilters(i);
                String uri = dsf.getUri();
                if (uri == null || !uri.startsWith("vap+internal:") || uri.length() <= 13) continue;
                for (String dep1 : dep = uri.substring(13).split(",")) {
                    if (DomUtil.getElementById(application, dep1) != null) continue;
                    problems.add("unable to find dsf " + dep1 + " for dsf " + dsf.getId());
                }
            }
            for (i = 0; i < application.getPlotElements().length; ++i) {
                p = application.getPlotElements(i);
                if (DomUtil.getElementById(application, ((PlotElement)p).getPlotId()) == null) {
                    problems.add("unable to find plot " + ((PlotElement)p).getPlotId() + " for plot element " + p.getId());
                }
                if (DomUtil.getElementById(application, ((PlotElement)p).getDataSourceFilterId()) != null) continue;
                problems.add("unable to find data " + ((PlotElement)p).getDataSourceFilterId() + " for plot element " + p.getId());
            }
            for (i = 0; i < application.getPlots().length; ++i) {
                p = application.getPlots(i);
                if (DomUtil.getElementById(application, ((Plot)p).getRowId()) == null) {
                    problems.add("unable to find row " + ((Plot)p).getRowId() + " for plot " + p.getId());
                }
                if (DomUtil.getElementById(application, ((Plot)p).getColumnId()) != null) continue;
                problems.add("unable to find column " + ((Plot)p).getColumnId() + " for plot  " + p.getId());
            }
            HashSet<String> ids = new HashSet<String>();
            DomUtil.checkIds(ids, application.getPlots(), problems);
            DomUtil.checkIds(ids, application.getPlotElements(), problems);
            DomUtil.checkIds(ids, application.getDataSourceFilters(), problems);
            DomUtil.checkIds(ids, application.getAnnotations(), problems);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return problems.isEmpty();
    }

    public static boolean structureChanges(Application dom, Application state) {
        if (dom.bindings.size() != state.bindings.size()) {
            return true;
        }
        if (dom.connectors.size() != state.connectors.size()) {
            return true;
        }
        if (dom.dataSourceFilters.size() != state.dataSourceFilters.size()) {
            return true;
        }
        if (dom.plots.size() != state.plots.size()) {
            return true;
        }
        if (dom.plotElements.size() != state.plotElements.size()) {
            return true;
        }
        for (int i = 0; i < dom.plots.size(); ++i) {
            Plot pd = dom.plots.get(i);
            Plot ps = state.plots.get(i);
            if (!pd.getXaxis().getRange().getUnits().isConvertibleTo(ps.getXaxis().getRange().getUnits())) {
                return true;
            }
            if (!pd.getYaxis().getRange().getUnits().isConvertibleTo(ps.getYaxis().getRange().getUnits())) {
                return true;
            }
            if (pd.getZaxis().getRange().getUnits().isConvertibleTo(ps.getZaxis().getRange().getUnits())) continue;
            return true;
        }
        return false;
    }

    public static List<PlotElement> getPlotElementsFor(Application application, Plot plot) {
        String id = plot.getId();
        ArrayList<PlotElement> result = new ArrayList<PlotElement>();
        for (PlotElement p : application.getPlotElements()) {
            if (!p.getPlotId().equals(id)) continue;
            result.add(p);
        }
        return result;
    }

    public static List<PlotElement> getPlotElementsFor(Application application, DataSourceFilter dsf) {
        String id = dsf.getId();
        return DomUtil.getPlotElementsFor(application, id);
    }

    private static List<PlotElement> getPlotElementsFor(Application application, String id) {
        ArrayList<PlotElement> result = new ArrayList<PlotElement>();
        for (PlotElement plotElement : application.getPlotElements()) {
            if (!plotElement.getDataSourceFilterId().equals(id)) continue;
            result.add(plotElement);
        }
        for (DomNode domNode : application.getDataSourceFilters()) {
            String[] ss;
            if (domNode == null) {
                logger.finer("found dsf that is null, which is done sometimes to mark as done.  Ignoring.");
                continue;
            }
            String uri = ((DataSourceFilter)domNode).getUri();
            if (!uri.startsWith("vap+internal:")) continue;
            for (String s : ss = uri.substring(13).split(",")) {
                if (!s.equals(id)) continue;
                List<PlotElement> pes1 = DomUtil.getPlotElementsFor(application, domNode.getId());
                result.addAll(pes1);
            }
        }
        return result;
    }

    public static boolean nodeHasProperty(DomNode node1, String property) {
        String[] props;
        for (String prop : props = BeansUtil.getPropertyNames(node1.getClass())) {
            if (!prop.equals(property)) continue;
            return true;
        }
        return false;
    }

    public static String resolveProperties(String template, String root, Map<String, Object> props) {
        try {
            int i = template.indexOf("%{" + root + ".");
            int n = root.length() + 3;
            while (i > -1) {
                int i2 = template.indexOf(125, i);
                String propName = template.substring(i + n, i2);
                int i3 = propName.indexOf(46);
                Map props1 = props;
                while (i3 > -1) {
                    String propName1 = propName.substring(0, i3);
                    props1 = (Map)props.get(propName1);
                    propName = propName.substring(i3 + 1);
                    i3 = propName.indexOf(46);
                }
                String prop = String.valueOf(props1.get(propName));
                template = template.substring(0, i) + prop + template.substring(i2 + 1);
                i = template.indexOf("%{" + root + ".", i);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "unable to resolve template: {0}", template);
            logger.log(Level.FINE, null, ex);
        }
        return template;
    }

    public static int getRowPositionPixels(Application dom, Row row, String position) {
        double dpos;
        Canvas c = dom.getCanvases(0);
        Font f = Font.decode(c.getFont());
        double em = f.getSize2D();
        String parent = row.getParent();
        if (parent.length() > 0) {
            DomNode n = DomUtil.getElementById(dom, parent);
            Row parentRow = (Row)n;
            int pmin = DomUtil.getRowPositionPixels(dom, parentRow, parentRow.getTop());
            int pmax = DomUtil.getRowPositionPixels(dom, parentRow, parentRow.getBottom());
            dpos = (double)pmin + DasColumn.parseLayoutStr((String)position, (double)em, (int)(pmax - pmin), (double)-1.0);
        } else {
            dpos = DasColumn.parseLayoutStr((String)position, (double)em, (int)c.getHeight(), (double)-1.0);
        }
        return (int)dpos;
    }

    public static int getColumnPositionPixels(Application dom, Column col, String position) {
        double dpos;
        Canvas c = dom.getCanvases(0);
        Font f = Font.decode(c.getFont());
        String parent = col.getParent();
        if (parent.length() > 0) {
            DomNode n = DomUtil.getElementById(dom, parent);
            Column parentColumn = (Column)n;
            int pmin = DomUtil.getColumnPositionPixels(dom, parentColumn, parentColumn.getLeft());
            int pmax = DomUtil.getColumnPositionPixels(dom, parentColumn, parentColumn.getRight());
            dpos = (double)pmin + DasColumn.parseLayoutStr((String)position, (double)f.getSize2D(), (int)(pmax - pmin), (double)-1.0);
        } else {
            dpos = DasColumn.parseLayoutStr((String)position, (double)f.getSize2D(), (int)c.getWidth(), (double)-1.0);
        }
        return (int)dpos;
    }

    public static Rectangle getBoundsForPlot(Application dom, Plot p) {
        Row row = (Row)DomUtil.getElementById(dom, p.getRowId());
        Column col = (Column)DomUtil.getElementById(dom, p.getColumnId());
        int c0 = DomUtil.getColumnPositionPixels(dom, col, col.getLeft());
        int c1 = DomUtil.getColumnPositionPixels(dom, col, col.getRight());
        int r0 = DomUtil.getRowPositionPixels(dom, row, row.getTop());
        int titleHeightLines = p.getTitle().trim().split("\n|\\<br\\>|\\!c", 2).length;
        int ems = Font.decode(dom.getCanvases((int)0).font).getSize();
        int r1 = DomUtil.getRowPositionPixels(dom, row, row.getBottom());
        return new Rectangle(c0, r0 -= titleHeightLines * ems, c1 - c0, r1 - r0);
    }

    public static Rectangle getBoundsForXAxis(Application dom, Plot p) {
        double[] tickLenEmPx;
        int r1;
        Axis xaxis = p.getXaxis();
        int emToPix = Font.decode(dom.getCanvases((int)0).font).getSize();
        Row row = (Row)DomUtil.getElementById(dom, p.getRowId());
        Column col = (Column)DomUtil.getElementById(dom, p.getColumnId());
        int c0 = DomUtil.getColumnPositionPixels(dom, col, col.getLeft());
        int c1 = DomUtil.getColumnPositionPixels(dom, col, col.getRight());
        int r0 = r1 = DomUtil.getRowPositionPixels(dom, row, row.getBottom());
        try {
            tickLenEmPx = DasDevicePosition.parseLayoutStr((String)dom.getOptions().getTicklen());
        }
        catch (ParseException ex) {
            tickLenEmPx = new double[]{0.0, 0.0, 0.0};
        }
        int tickLen = Math.max(0, (int)Math.round(tickLenEmPx[1] * (double)emToPix + tickLenEmPx[2]));
        if (xaxis.isVisible()) {
            int axisLines;
            if (xaxis.isDrawTickLabels()) {
                axisLines = 1;
                String label = xaxis.getLabel().trim();
                if (label.length() > 0) {
                    axisLines += 1 + label.split("\n|\\<br\\>|\\!c", 2).length;
                }
                if (p.getTicksURI().trim().length() > 0) {
                    if (p.getEphemerisLineCount() > -1) {
                        axisLines += p.getEphemerisLineCount();
                    } else if (p.getEphemerisLabels().trim().length() > 0) {
                        axisLines += p.getEphemerisLabels().split(";").length;
                    } else {
                        int nominalNumberOfTicksLines = 5;
                        axisLines += nominalNumberOfTicksLines;
                    }
                }
            } else {
                axisLines = 0;
            }
            r1 = r1 + axisLines * emToPix + tickLen;
        }
        return new Rectangle(c0, r0, c1 - c0, r1 - r0);
    }

    public static Rectangle getBoundsForZAxis(Application dom, Plot p) {
        int c0;
        Axis zaxis = p.getZaxis();
        Row row = (Row)DomUtil.getElementById(dom, p.getRowId());
        Column col = (Column)DomUtil.getElementById(dom, p.getColumnId());
        int c1 = c0 = DomUtil.getColumnPositionPixels(dom, col, col.getRight());
        int r0 = DomUtil.getRowPositionPixels(dom, row, row.getTop());
        int r1 = DomUtil.getRowPositionPixels(dom, row, row.getBottom());
        int axisLines = 5 + zaxis.getLabel().trim().split("\n|\\<br\\>|\\!c", 2).length;
        if (p.getTicksURI().trim().length() > 0) {
            int nominalNumberOfTicksLines = 5;
            axisLines += nominalNumberOfTicksLines;
        }
        int ems = Font.decode(dom.getCanvases((int)0).font).getSize();
        return new Rectangle(c0, r0, (c1 += axisLines * ems) - c0, r1 - r0);
    }

    public static BindingModel findBinding(Application dom, DomNode src, String srcProp, DomNode dst, String dstProp) {
        List<BindingModel> results = DomUtil.findBindings(dom, src, srcProp, dst, dstProp);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public static List<BindingModel> findBindings(Application dom, DomNode src, String srcProp) {
        List<BindingModel> bindings = DomUtil.findBindings(dom, src, srcProp, null, null);
        List<BindingModel> bindings2 = DomUtil.findBindings(dom, null, null, src, srcProp);
        bindings2.removeAll(bindings);
        bindings.addAll(bindings2);
        return bindings;
    }

    public static List<BindingModel> findBindings(Application dom, DomNode src, String srcProp, DomNode dst, String dstProp) {
        ArrayList<BindingModel> result = new ArrayList<BindingModel>();
        for (BindingModel b : dom.getBindings()) {
            if (!(src != null && !b.getSrcId().equals(src.getId()) || dst != null && !b.getDstId().equals(dst.getId()) || srcProp != null && !b.getSrcProperty().equals(srcProp) || dstProp != null && !b.getDstProperty().equals(dstProp))) {
                result.add(b);
                continue;
            }
            if (dst != null && !b.getSrcId().equals(dst.getId()) || src != null && !b.getDstId().equals(src.getId()) || dstProp != null && !b.getSrcProperty().equals(dstProp) || srcProp != null && !b.getDstProperty().equals(srcProp)) continue;
            result.add(b);
        }
        return result;
    }

    public static List<BindingModel> findBindings(Application dom, List<DomNode> src, String srcProp, List<DomNode> dst, String dstProp) {
        ArrayList<BindingModel> result = new ArrayList<BindingModel>();
        ArrayList<String> ssrc = null;
        ArrayList<String> sdst = null;
        if (src != null) {
            ssrc = new ArrayList<String>();
            for (DomNode n : src) {
                ssrc.add(n.id);
            }
        }
        if (dst != null) {
            sdst = new ArrayList<String>();
            for (DomNode n : dst) {
                sdst.add(n.id);
            }
        }
        for (BindingModel b : dom.getBindings()) {
            if (!(ssrc != null && !ssrc.contains(b.getSrcId()) || sdst != null && !sdst.contains(b.getDstId()) || srcProp != null && !b.getSrcProperty().equals(srcProp) || dstProp != null && !b.getDstProperty().equals(dstProp))) {
                result.add(b);
                continue;
            }
            if (sdst != null && !sdst.contains(b.getDstId()) || ssrc != null && !ssrc.contains(b.getSrcId()) || dstProp != null && !b.getSrcProperty().equals(dstProp) || srcProp != null && !b.getDstProperty().equals(srcProp)) continue;
            result.add(b);
        }
        return result;
    }

    public static void findListeners(Object o, String prop) {
        if (o instanceof DomNode) {
            PropertyChangeSupport pcs = ((DomNode)o).propertyChangeSupport;
            if (pcs instanceof DebugPropertyChangeSupport) {
                ((DebugPropertyChangeSupport)pcs).printListeners(prop);
            }
        } else if (o instanceof DomNodeController) {
            PropertyChangeSupport pcs = ((DomNodeController)o).propertyChangeSupport;
            if (pcs instanceof DebugPropertyChangeSupport) {
                ((DebugPropertyChangeSupport)pcs).printListeners(prop);
            }
        } else {
            System.err.println("Not supported: " + o);
        }
    }

    public static void applyMacro(DomNode state, String node, String sval) {
        String[] props = BeansUtil.getPropertyNames(state.getClass());
        PropertyDescriptor[] pds = BeansUtil.getPropertyDescriptors(state.getClass());
        for (int i = 0; i < props.length; ++i) {
            if (props[i].equals("controller")) continue;
            try {
                String sval1;
                Method m;
                if (pds[i] instanceof IndexedPropertyDescriptor) {
                    m = pds[i].getReadMethod();
                    if (m == null) continue;
                    Object vals1 = m.invoke((Object)state, new Object[0]);
                    for (int j = 0; j < Array.getLength(vals1); ++j) {
                        Object val1 = Array.get(vals1, j);
                        if (val1 instanceof DomNode) {
                            DomUtil.applyMacro((DomNode)val1, node, sval);
                            continue;
                        }
                        if (!(val1 instanceof String)) continue;
                        System.err.println(val1);
                        String sval12 = (String)val1;
                        if (!sval12.contains(node)) continue;
                        sval12 = sval12.replaceAll(node, sval);
                        pds[i].getWriteMethod().invoke((Object)state, sval12);
                    }
                    continue;
                }
                m = pds[i].getReadMethod();
                if (m == null) continue;
                Object val1 = m.invoke((Object)state, new Object[0]);
                if (val1 instanceof DomNode) {
                    DomUtil.applyMacro((DomNode)val1, node, sval);
                    continue;
                }
                if (!(val1 instanceof String) || !(sval1 = (String)val1).contains(node)) continue;
                sval1 = sval1.replace(node, sval);
                pds[i].getWriteMethod().invoke((Object)state, sval1);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public static Row getRow(Application dom, String id) {
        Canvas canvas = dom.getCanvases(0);
        if (canvas.marginRow.id.equals(id)) {
            return canvas.marginRow;
        }
        for (Row r : canvas.getRows()) {
            if (!r.id.equals(id)) continue;
            return r;
        }
        throw new IllegalArgumentException("Unable to find row: " + id);
    }

    public static Column getColumn(Application dom, String id) {
        Canvas canvas = dom.getCanvases(0);
        if (canvas.marginColumn.id.equals(id)) {
            return canvas.marginColumn;
        }
        for (Column c : canvas.getColumns()) {
            if (!c.id.equals(id)) continue;
            return c;
        }
        throw new IllegalArgumentException("Unable to find column: " + id);
    }

    public static Plot getPlot(Application dom, String id) {
        for (Plot p : dom.plots) {
            if (!p.id.equals(id)) continue;
            return p;
        }
        throw new IllegalArgumentException("Unable to find plot: " + id);
    }

    public static PlotElement getPlotElement(Application dom, String id) {
        for (PlotElement p : dom.plotElements) {
            if (!p.id.equals(id)) continue;
            return p;
        }
        throw new IllegalArgumentException("Unable to find plotElement: " + id);
    }

    private static boolean isContained(List<Plot> ps, BindingModel bm) {
        boolean srcContained = false;
        boolean dstContained = false;
        for (Plot p : ps) {
            String id = p.getId();
            boolean srcContained1 = id.equals(bm.srcId) || p.getXaxis().getId().equals(bm.srcId) || p.getYaxis().getId().equals(bm.srcId);
            boolean dstContained1 = id.equals(bm.dstId) || p.getXaxis().getId().equals(bm.dstId) || p.getYaxis().getId().equals(bm.dstId);
            srcContained = srcContained || srcContained1;
            dstContained = dstContained || dstContained1;
        }
        return srcContained && dstContained;
    }

    public static String getPlotAsString(Application application, Plot domPlot) {
        Application newApp = new Application();
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (Plot p : application.getPlots()) {
            if (p.getRowId().equals(domPlot.getRowId()) && p.getColumnId().equals(domPlot.getColumnId())) {
                plots.add(p);
                continue;
            }
            Row row = DomUtil.getRow(application, p.getRowId());
            Column column = DomUtil.getColumn(application, p.getColumnId());
            if (!row.getParent().equals(domPlot.getRowId()) || !column.getParent().equals(domPlot.getColumnId())) continue;
            plots.add(p);
        }
        newApp.setPlots(plots.toArray(new Plot[0]));
        ArrayList<DomNode> dnplots = new ArrayList<DomNode>();
        for (Plot p : plots) {
            dnplots.add(p);
            dnplots.add(p.getXaxis());
            dnplots.add(p.getYaxis());
            dnplots.add(p.getZaxis());
        }
        List<BindingModel> bb = DomUtil.findBindings(application, dnplots, null, dnplots, null);
        newApp.setBindings(bb.toArray(new BindingModel[0]));
        ArrayList<PlotElement> pes = new ArrayList<PlotElement>();
        ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>();
        for (Plot plot : plots) {
            List<PlotElement> pes1 = DomUtil.getPlotElementsFor(application, plot);
            pes.addAll(pes1);
            List<DataSourceFilter> dsfs1 = DomUtil.getDataSourceFiltersFor(application, plot);
            dsfs.addAll(dsfs1);
        }
        newApp.setPlotElements(pes.toArray(new PlotElement[0]));
        newApp.setDataSourceFilters(dsfs.toArray(new DataSourceFilter[0]));
        newApp.setCanvases(application.getCanvases());
        newApp.setId(application.id + "_" + domPlot.id);
        ArrayList<BindingModel> newAppBm = new ArrayList<BindingModel>();
        for (BindingModel bm : application.getBindings()) {
            if (!DomUtil.isContained(plots, bm)) continue;
            newAppBm.add(bm);
        }
        if (!newAppBm.isEmpty()) {
            newApp.setBindings(newAppBm.toArray(new BindingModel[0]));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        try {
            StatePersistence.saveState(byteArrayOutputStream, (Object)newApp, "");
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<DataSourceFilter> getDataSourceFiltersFor(Application dom, Plot p) {
        ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>();
        List<PlotElement> pes = DomUtil.getPlotElementsFor(dom, p);
        for (PlotElement pe : pes) {
            DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, pe.getDataSourceFilterId());
            dsfs.add(dsf);
            if (!dsf.getUri().startsWith("vap+internal:")) continue;
            dsfs.addAll(DomUtil.getParentsFor(dom, dsf.getUri()));
        }
        return dsfs;
    }

    private static ArrayList<String> vapToJython(ArrayList<String> jython, String nodeAddress, PropertyChangeDiff pcd) {
        String s;
        String propertyName = pcd.propertyName;
        if (propertyName.endsWith("scale")) {
            return jython;
        }
        if (propertyName.endsWith("autoLabel")) {
            return jython;
        }
        if (propertyName.startsWith("options")) {
            return jython;
        }
        Object o = pcd.newVal;
        if (o instanceof String) {
            s = "'" + o + "'";
        } else if (o instanceof Boolean) {
            s = o.toString();
            s = String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
        } else if (o instanceof Color) {
            Color c = (Color)o;
            s = "color('" + ColorUtil.nameForColor((Color)c) + "')";
        } else if (o instanceof DatumRange) {
            s = "datumRange('" + o + "')";
        } else if (o instanceof Datum) {
            s = "datum('" + o + "')";
        } else if (o instanceof Enum) {
            String sclaz = ((Enum)o).getDeclaringClass().getCanonicalName();
            jython.add("import " + sclaz);
            s = "" + sclaz + "." + o;
        } else if (o instanceof Displayable) {
            String sclaz = ((Displayable)o).getClass().getCanonicalName();
            jython.add("import " + sclaz);
            s = "" + sclaz + "." + o.toString().toUpperCase();
        } else {
            s = String.valueOf(o);
        }
        jython.add(nodeAddress + "." + pcd.propertyName + " = " + s);
        return jython;
    }

    private static ArrayList<String> vapToJython(String nodeAddress, DomNode src, DomNode dst) {
        ArrayList<String> jython = new ArrayList<String>();
        List<Diff> diffs = dst.diffs(src);
        for (Diff d : diffs) {
            if (d instanceof PropertyChangeDiff) {
                jython = DomUtil.vapToJython(jython, nodeAddress, (PropertyChangeDiff)d);
                continue;
            }
            throw new IllegalArgumentException("only property change diffs!");
        }
        return jython;
    }

    public static String[] vapToJython(Application app0, Application app) {
        ArrayList<String> jython = new ArrayList<String>();
        List<Diff> diffs = app0.diffs(app);
        for (Diff d : diffs) {
            if (d instanceof PropertyChangeDiff) {
                PropertyChangeDiff pcd = (PropertyChangeDiff)d;
                jython = DomUtil.vapToJython(jython, "dom", pcd);
                continue;
            }
            if (d instanceof ArrayNodeDiff) {
                ArrayNodeDiff and = (ArrayNodeDiff)d;
                if (null == and.action) continue;
                switch (and.action) {
                    case Insert: {
                        if (and.node instanceof Annotation) {
                            jython.add("from org.autoplot.dom import Annotation");
                            jython.add("dom.controller.addAnnotation(Annotation())");
                            jython.addAll(DomUtil.vapToJython("dom.annotations[" + and.index + "]", new Annotation(), (DomNode)and.node));
                            break;
                        }
                        if (and.node instanceof Plot) {
                            jython.add("from org.autoplot.dom import Plot");
                            jython.add("dom.controller.addPlot(Plot())");
                            jython.addAll(DomUtil.vapToJython("dom.plots[" + and.index + "]", new Plot(), (DomNode)and.node));
                            break;
                        }
                        if (and.node instanceof Row || and.node instanceof Column) break;
                        if (and.node instanceof DataSourceFilter) {
                            jython.add("from org.autoplot.dom import DataSourceFilter");
                            jython.add("dom.controller.addDataSourceFilter()");
                            jython.addAll(DomUtil.vapToJython("dom.dataSourceFilters[" + and.index + "]", new DataSourceFilter(), (DomNode)and.node));
                            break;
                        }
                        if (and.node instanceof PlotElement) {
                            jython.add("from org.autoplot.dom import PlotElement");
                            jython.add("dom.controller.addPlotElement(None,None)");
                            jython.addAll(DomUtil.vapToJython("dom.plotElements[" + and.index + "]", new PlotElement(), (DomNode)and.node));
                            break;
                        }
                        if (and.node instanceof BindingModel) {
                            BindingModel bm = (BindingModel)and.node;
                            jython.add("bind( dom.getElementById('" + bm.srcId + "'), '" + bm.srcProperty + "' ,dom.getElementById('" + bm.dstId + "'), '" + bm.dstProperty + "' )");
                            break;
                        }
                        jython.add("insert " + d.toString());
                        break;
                    }
                    case Delete: {
                        jython.add("delete " + d.toString());
                        break;
                    }
                    case Move: {
                        jython.add("move " + d.toString());
                        break;
                    }
                }
                continue;
            }
            jython.add(d.toString());
        }
        return jython.toArray(new String[jython.size()]);
    }

    public static String layoutToString(Canvas c) {
        Row arow = c.getRows(0);
        return String.format("\u2610 %dx%d %dpt %s %s %s", c.width, c.height, Font.decode(c.font).getSize(), "||" + c.marginColumn.getLeft() + "," + c.marginColumn.getRight(), "=" + c.marginRow.getTop() + "," + c.marginRow.getBottom(), "=" + arow.getTop() + "," + arow.getBottom());
    }

    public static void deleteDuplicateIds(Application state) {
        if (state.controller != null) {
            throw new IllegalArgumentException("application can not have a controller.");
        }
        HashSet<String> s = new HashSet<String>();
        ArrayList<Annotation> ann = new ArrayList<Annotation>();
        for (Annotation a : state.getAnnotations()) {
            if (s.contains(a.id)) continue;
            ann.add(a);
        }
        state.setAnnotations(ann.toArray(new Annotation[ann.size()]));
        s = new HashSet();
        ArrayList<DataSourceFilter> ff = new ArrayList<DataSourceFilter>();
        for (DataSourceFilter a : state.getDataSourceFilters()) {
            if (!s.contains(a.id)) {
                ff.add(a);
            }
            s.add(a.id);
        }
        state.setDataSourceFilters(ff.toArray(new DataSourceFilter[ff.size()]));
        s = new HashSet();
        ArrayList<PlotElement> pes = new ArrayList<PlotElement>();
        for (PlotElement a : state.getPlotElements()) {
            if (!s.contains(a.id)) {
                pes.add(a);
            }
            s.add(a.id);
        }
        state.setPlotElements(pes.toArray(new PlotElement[pes.size()]));
        s = new HashSet();
        ArrayList<Plot> ps = new ArrayList<Plot>();
        for (Plot a : state.getPlots()) {
            if (!s.contains(a.id)) {
                ps.add(a);
            }
            s.add(a.id);
        }
        state.setPlots(ps.toArray(new Plot[ps.size()]));
    }

    public static List<String> checkUniqueIdsAndReferences(Application dom, List<String> problems) {
        DomNode n1;
        HashMap<String, DomNode> ids = new HashMap<String, DomNode>();
        for (DomNode domNode : dom.dataSourceFilters) {
            DomNode n12 = (DomNode)ids.get(domNode.id);
            if (n12 != null) {
                problems.add("DataSourceFilter id is already taken by " + n12 + ".");
                continue;
            }
            ids.put(domNode.id, domNode);
        }
        ArrayList<Column> cc = new ArrayList<Column>(dom.getCanvases((int)0).columns);
        cc.add(dom.getCanvases((int)0).marginColumn);
        for (Column n : cc) {
            DomNode domNode = (DomNode)ids.get(n.id);
            if (domNode != null) {
                problems.add("Column id is already taken by " + domNode + ".");
            } else {
                ids.put(n.id, n);
            }
            if (!n.getParent().equals(dom.getCanvases((int)0).marginRow.id)) continue;
            problems.add("Column parent is a row: " + n.id + ".");
        }
        ArrayList<Row> arrayList = new ArrayList<Row>(dom.getCanvases((int)0).rows);
        arrayList.add(dom.getCanvases((int)0).marginRow);
        for (Row row : arrayList) {
            n1 = (DomNode)ids.get(row.id);
            if (n1 != null) {
                problems.add("Row id is already taken by " + n1 + ".");
                continue;
            }
            ids.put(row.id, row);
        }
        for (Plot plot : dom.plots) {
            n1 = (DomNode)ids.get(plot.id);
            if (n1 != null) {
                problems.add("Plot id is already taken by " + n1 + ".");
            } else {
                ids.put(plot.id, plot);
            }
            if (ids.get(plot.getRowId()) == null) {
                problems.add("PlotElement refers to row '" + plot.getRowId() + "' which is not found: " + plot);
            }
            if (ids.get(plot.getColumnId()) != null) continue;
            problems.add("PlotElement refers to column '" + plot.getColumnId() + "' which is not found: " + plot);
        }
        for (PlotElement plotElement : dom.plotElements) {
            n1 = (DomNode)ids.get(plotElement.id);
            if (n1 != null) {
                problems.add("PlotElement id is already taken by " + n1 + ".");
            } else {
                ids.put(plotElement.id, plotElement);
            }
            if (ids.get(plotElement.plotId) == null) {
                problems.add("PlotElement refers to plot '" + plotElement.plotId + "' which is not found: " + plotElement);
            }
            if (ids.get(plotElement.dataSourceFilterId) != null) continue;
            problems.add("PlotElement refers to dataSourceFilter '" + plotElement.dataSourceFilterId + "' which is not found: " + plotElement);
        }
        for (Connector connector : dom.connectors) {
            n1 = (DomNode)ids.get(connector.id);
            if (n1 != null) {
                problems.add("Connector id is already taken by " + n1 + ".");
            } else {
                ids.put(connector.id, connector);
            }
            if (ids.get(connector.plotA) == null) {
                problems.add("Connector refers to plot '" + connector.plotA + "' which is not found: " + connector);
            }
            if (ids.get(connector.plotB) != null) continue;
            problems.add("Connector refers to plot '" + connector.plotB + "' which is not found: " + connector);
        }
        for (Annotation annotation : dom.annotations) {
            n1 = (DomNode)ids.get(annotation.id);
            if (n1 != null) {
                problems.add("Annotation id is already taken by " + n1 + ".");
            } else {
                ids.put(annotation.id, annotation);
            }
            if (annotation.getPlotId().length() > 0 && ids.get(annotation.getPlotId()) == null) {
                problems.add("Annotation refers to plot '" + annotation.getPlotId() + "' which is not found: " + annotation);
            }
            if (annotation.getColumnId().trim().length() > 0 && ids.get(annotation.getColumnId()) == null) {
                problems.add("Annotation refers to column '" + annotation.getColumnId() + "' which is not found: " + annotation);
            }
            if (annotation.getRowId().trim().length() <= 0 || ids.get(annotation.getRowId()) != null) continue;
            problems.add("Annotation refers to row '" + annotation.getRowId() + "' which is not found: " + annotation);
        }
        return problems;
    }

    public static void copyOverInternalData(Application srcdom, Application dstdom) {
        DataSourceFilter[] dstdsfs;
        DataSourceFilter[] srcdsfs = srcdom.getDataSourceFilters();
        if (srcdsfs.length != (dstdsfs = dstdom.getDataSourceFilters()).length) {
            throw new IllegalArgumentException("src and dest doms must be the same length.");
        }
        if (dstdsfs.length > 0 && dstdsfs[0].getController() == null) {
            logger.warning("destination does not have controllers, internal data in src will be ignored.");
            return;
        }
        for (int i = 0; i < srcdsfs.length; ++i) {
            if (!srcdsfs[i].getUri().equals("vap+internal:") || srcdsfs[i].getController() == null) continue;
            QDataSet ds = srcdsfs[i].getController().getFillDataSet();
            dstdsfs[i].getController().setDataSetInternal(ds);
        }
    }
}

